/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.animation.statemachine;

import com.tacz.guns.api.client.animation.AnimationController;
import com.tacz.guns.api.client.animation.AnimationPlan;
import com.tacz.guns.api.client.animation.ObjectAnimation;
import com.tacz.guns.api.client.animation.ObjectAnimationRunner;
import com.tacz.guns.client.animation.statemachine.WalkDirection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayDeque;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_3532;
import net.minecraft.class_744;

@Environment(value=EnvType.CLIENT)
public class GunAnimationStateMachine {
    protected static final IntSet BLENDING_TRACKS = new IntLinkedOpenHashSet();
    protected static int TRACK_INDEX_TOP = 0;
    public static final int HOLDING_POSE_STATIC_TRACK = GunAnimationStateMachine.staticTrack();
    public static final int BOLT_CATCH_STATIC_TRACK = GunAnimationStateMachine.staticTrack();
    public static final int MAIN_TRACK = GunAnimationStateMachine.staticTrack();
    public static final int MOVEMENT_TRACK = GunAnimationStateMachine.blendingTrack();
    public static final int[] SHOOTING_TRACKS = new int[]{GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack(), GunAnimationStateMachine.blendingTrack()};
    protected AnimationController controller;
    protected boolean noAmmo = false;
    protected boolean magExtended = false;
    protected boolean onGround = true;
    protected boolean pauseWalkAndRun = false;
    protected boolean isAiming = false;
    protected float baseDistanceWalked = 0.0f;
    protected float keepDistanceWalked = 0.0f;
    protected WalkDirection lastWalkDirection = WalkDirection.NONE;
    protected boolean isWalkAiming = false;

    public GunAnimationStateMachine(AnimationController controller) {
        this.controller = controller;
        for (int i = 0; i < TRACK_INDEX_TOP; ++i) {
            controller.setBlending(i, BLENDING_TRACKS.contains(i));
        }
    }

    protected static int staticTrack() {
        return TRACK_INDEX_TOP++;
    }

    protected static int blendingTrack() {
        int track = TRACK_INDEX_TOP++;
        BLENDING_TRACKS.add(track);
        return track;
    }

    public void onGunShoot() {
        if (this.isPlayingInspectAnimation()) {
            this.controller.removeAnimation(MAIN_TRACK);
        }
        for (int track : SHOOTING_TRACKS) {
            if (!this.tryRunShootAnimation(track)) continue;
            return;
        }
        this.controller.runAnimation(SHOOTING_TRACKS[0], "shoot", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.0f);
    }

    public void onGunReload() {
        if (this.noAmmo) {
            if (this.magExtended && this.controller.containPrototype("reload_empty_extended")) {
                this.controller.runAnimation(MAIN_TRACK, "reload_empty_extended", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.2f);
            } else {
                this.controller.runAnimation(MAIN_TRACK, "reload_empty", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.2f);
            }
        } else if (this.magExtended && this.controller.containPrototype("reload_tactical_extended")) {
            this.controller.runAnimation(MAIN_TRACK, "reload_tactical_extended", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.2f);
        } else {
            this.controller.runAnimation(MAIN_TRACK, "reload_tactical", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.2f);
        }
    }

    public void onGunBolt() {
        this.controller.runAnimation(MAIN_TRACK, "bolt", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.2f);
    }

    public void onBayonetAttack(int count) {
        String animationName = "melee_bayonet_" + class_3532.method_15340((int)(count + 1), (int)1, (int)3);
        this.controller.runAnimation(MAIN_TRACK, animationName, ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.2f);
    }

    public void onStockAttack() {
        this.controller.runAnimation(MAIN_TRACK, "melee_stock", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.2f);
    }

    public void onPushAttack() {
        this.controller.runAnimation(MAIN_TRACK, "melee_push", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.2f);
    }

    public void onGunDraw() {
        this.controller.runAnimation(MOVEMENT_TRACK, "idle", ObjectAnimation.PlayType.LOOP, 0.0f);
        this.lastWalkDirection = WalkDirection.NONE;
        this.controller.runAnimation(MAIN_TRACK, "draw", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.0f);
    }

    public void onShooterRun(float walkDist) {
        if (this.isPlayingRunIntroOrLoop()) {
            if (!this.onGround && !this.isPlayingRunHold()) {
                this.controller.runAnimation(MOVEMENT_TRACK, "run_hold", ObjectAnimation.PlayType.LOOP, 0.6f);
                this.isWalkAiming = false;
                this.lastWalkDirection = WalkDirection.NONE;
            }
            return;
        }
        if (this.onGround) {
            ArrayDeque<AnimationPlan> deque = new ArrayDeque<AnimationPlan>();
            if (!this.isPlayingRunHold()) {
                deque.add(new AnimationPlan("run_start", ObjectAnimation.PlayType.PLAY_ONCE_HOLD, 0.2f));
            }
            deque.add(new AnimationPlan("run", ObjectAnimation.PlayType.LOOP, 0.2f));
            this.controller.queueAnimation(MOVEMENT_TRACK, deque);
            this.isWalkAiming = false;
            this.lastWalkDirection = WalkDirection.NONE;
            this.baseDistanceWalked = walkDist;
        }
    }

    public void onGunPutAway(float putAwayTimeS) {
        this.controller.runAnimation(MAIN_TRACK, "put_away", ObjectAnimation.PlayType.PLAY_ONCE_HOLD, putAwayTimeS * 0.75f);
        ObjectAnimationRunner runner = this.controller.getAnimation(MAIN_TRACK);
        if (runner != null) {
            if (runner.isRunning() && "put_away".equals(runner.getAnimation().name)) {
                long progress = (long)((double)Math.max(runner.getAnimation().getMaxEndTimeS() - putAwayTimeS, 0.0f) * 1.0E9);
                runner.setProgressNs(progress);
                return;
            }
            if (runner.getTransitionTo() != null && "put_away".equals(runner.getTransitionTo().getAnimation().name)) {
                long progress = (long)((double)Math.max(runner.getTransitionTo().getAnimation().getMaxEndTimeS() - putAwayTimeS, 0.0f) * 1.0E9);
                runner.getTransitionTo().setProgressNs(progress);
            }
        }
    }

    public void onShooterIdle() {
        if (this.isPlayingIdleAnimation()) {
            return;
        }
        ObjectAnimationRunner runner = this.controller.getAnimation(MOVEMENT_TRACK);
        if (!(runner == null || !runner.isRunning() && !runner.isTransitioning() || this.isPlayingWalkAnimation() || this.isPlayingRunIntroOrLoop() || this.isPlayingRunHold())) {
            return;
        }
        this.isWalkAiming = false;
        this.lastWalkDirection = WalkDirection.NONE;
        ArrayDeque<AnimationPlan> deque = new ArrayDeque<AnimationPlan>();
        if (this.isPlayingRunIntroOrLoop()) {
            deque.add(new AnimationPlan("run_end", ObjectAnimation.PlayType.PLAY_ONCE_HOLD, 0.3f));
        }
        deque.add(new AnimationPlan("idle", ObjectAnimation.PlayType.LOOP, 0.4f));
        this.controller.queueAnimation(MOVEMENT_TRACK, deque);
    }

    public void onGunInspect() {
        if (this.noAmmo) {
            this.controller.runAnimation(MAIN_TRACK, "inspect_empty", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.2f);
        } else {
            this.controller.runAnimation(MAIN_TRACK, "inspect", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.2f);
        }
    }

    public void onShooterWalk(class_744 input, float walkDist) {
        if (!this.onGround && !this.isPlayingIdleAnimation()) {
            this.controller.runAnimation(MOVEMENT_TRACK, "idle", ObjectAnimation.PlayType.LOOP, 0.6f);
            this.isWalkAiming = false;
            this.lastWalkDirection = WalkDirection.NONE;
            return;
        }
        if (this.onGround) {
            if (this.isAiming) {
                if (this.isWalkAiming) {
                    return;
                }
                this.isWalkAiming = true;
                this.lastWalkDirection = WalkDirection.NONE;
                ArrayDeque<AnimationPlan> deque = new ArrayDeque<AnimationPlan>();
                if (this.isPlayingRunIntroOrLoop() || this.isPlayingRunHold()) {
                    deque.add(new AnimationPlan("run_end", ObjectAnimation.PlayType.PLAY_ONCE_HOLD, 0.3f));
                }
                deque.add(new AnimationPlan("walk_aiming", ObjectAnimation.PlayType.LOOP, 0.3f));
                this.controller.queueAnimation(MOVEMENT_TRACK, deque);
                this.baseDistanceWalked = walkDist;
                return;
            }
            WalkDirection direction = WalkDirection.fromInput(input);
            if (direction == this.lastWalkDirection) {
                return;
            }
            this.isWalkAiming = false;
            this.lastWalkDirection = direction;
            ArrayDeque<AnimationPlan> deque = new ArrayDeque<AnimationPlan>();
            if (this.isPlayingRunIntroOrLoop() || this.isPlayingRunHold()) {
                deque.add(new AnimationPlan("run_end", ObjectAnimation.PlayType.PLAY_ONCE_HOLD, 0.3f));
            }
            switch (direction) {
                case FORWARD: {
                    deque.add(new AnimationPlan("walk_forward", ObjectAnimation.PlayType.LOOP, 0.4f));
                    break;
                }
                case BACKWARD: {
                    deque.add(new AnimationPlan("walk_backward", ObjectAnimation.PlayType.LOOP, 0.4f));
                    break;
                }
                case SIDE_WAY: {
                    deque.add(new AnimationPlan("walk_sideway", ObjectAnimation.PlayType.LOOP, 0.4f));
                }
            }
            this.controller.queueAnimation(MOVEMENT_TRACK, deque);
            this.baseDistanceWalked = walkDist;
        }
    }

    public void onGunFireSelect() {
    }

    public void onGunCatchBolt() {
        if (!this.isPlayingAnimation(BOLT_CATCH_STATIC_TRACK, "static_bolt_caught")) {
            this.controller.runAnimation(BOLT_CATCH_STATIC_TRACK, "static_bolt_caught", ObjectAnimation.PlayType.LOOP, 0.0f);
        }
    }

    public GunAnimationStateMachine setNoAmmo(boolean noAmmo) {
        this.noAmmo = noAmmo;
        return this;
    }

    public GunAnimationStateMachine setMagExtended(boolean magExtended) {
        this.magExtended = magExtended;
        return this;
    }

    public GunAnimationStateMachine setOnGround(boolean onGround) {
        this.onGround = onGround;
        return this;
    }

    public GunAnimationStateMachine setPauseWalkAndRun(boolean pause) {
        this.pauseWalkAndRun = pause;
        return this;
    }

    public GunAnimationStateMachine setAiming(boolean isAiming) {
        this.isAiming = isAiming;
        return this;
    }

    public AnimationController getController() {
        return this.controller;
    }

    public boolean shouldHideCrossHair() {
        if (this.isPlayingInspectAnimation()) {
            return true;
        }
        return this.isPlayingRunHold() || this.isPlayingRunLoop();
    }

    public void update(float partialTicks, class_1297 entity) {
        ObjectAnimationRunner runner = this.controller.getAnimation(MOVEMENT_TRACK);
        if (runner != null) {
            float distanceWalked;
            float deltaDistanceWalked = entity.field_5973 - entity.field_6039;
            if (this.pauseWalkAndRun) {
                distanceWalked = this.keepDistanceWalked;
                this.baseDistanceWalked = entity.field_5973 + deltaDistanceWalked * partialTicks - this.keepDistanceWalked;
            } else {
                this.keepDistanceWalked = distanceWalked = entity.field_5973 + deltaDistanceWalked * partialTicks - this.baseDistanceWalked;
            }
            String animationName = runner.getAnimation().name;
            if ((this.isNamedWalkAnimation(animationName) || "run".equals(animationName)) && runner.isRunning()) {
                runner.setProgressNs((long)(runner.getAnimation().getMaxEndTimeS() * (distanceWalked % 2.0f) / 2.0f * 1.0E9f));
            }
            if (runner.isTransitioning() && runner.getTransitionTo() != null && (this.isNamedWalkAnimation(animationName = runner.getTransitionTo().getAnimation().name) || "run".equals(animationName))) {
                runner.getTransitionTo().setProgressNs((long)(runner.getTransitionTo().getAnimation().getMaxEndTimeS() * (distanceWalked % 2.0f) / 2.0f * 1.0E9f));
            }
        }
        this.controller.update();
    }

    public boolean isPlayingAnimation(int track, String ... names) {
        ObjectAnimationRunner runner = this.controller.getAnimation(track);
        if (runner != null) {
            String animationName = runner.getAnimation().name;
            if (runner.isRunning()) {
                for (String name : names) {
                    if (!name.equals(animationName)) continue;
                    return true;
                }
            }
            if (runner.isTransitioning() && runner.getTransitionTo() != null) {
                animationName = runner.getTransitionTo().getAnimation().name;
                for (String name : names) {
                    if (!name.equals(animationName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPlayingRunAnimation() {
        return this.isPlayingAnimation(MOVEMENT_TRACK, "run_start", "run", "run_hold", "run_end");
    }

    public boolean isPlayingRunIntroOrLoop() {
        return this.isPlayingAnimation(MOVEMENT_TRACK, "run", "run_start");
    }

    public boolean isPlayingRunStart() {
        return this.isPlayingAnimation(MOVEMENT_TRACK, "run_start");
    }

    public boolean isPlayingRunLoop() {
        return this.isPlayingAnimation(MOVEMENT_TRACK, "run");
    }

    public boolean isPlayingRunHold() {
        return this.isPlayingAnimation(MOVEMENT_TRACK, "run_hold");
    }

    public boolean isPlayingRunEnd() {
        return this.isPlayingAnimation(MOVEMENT_TRACK, "run_end");
    }

    public boolean isPlayingWalkAnimation() {
        return this.isPlayingAnimation(MOVEMENT_TRACK, "walk_forward", "walk_backward", "walk_sideway", "walk_aiming");
    }

    public boolean isPlayingIdleAnimation() {
        return this.isPlayingAnimation(MOVEMENT_TRACK, "idle");
    }

    public boolean isPlayingShootAnimation() {
        for (int track : SHOOTING_TRACKS) {
            ObjectAnimationRunner runner = this.controller.getAnimation(track);
            if (runner == null) continue;
            if (runner.isRunning()) {
                return true;
            }
            if (!runner.isTransitioning() || runner.getTransitionTo() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayingInspectAnimation() {
        return this.isPlayingAnimation(MAIN_TRACK, "inspect", "inspect_empty");
    }

    public boolean isPlayingReloadAnimation() {
        return this.isPlayingAnimation(MAIN_TRACK, "reload_empty", "reload_tactical");
    }

    public boolean isPlayingDrawAnimation() {
        return this.isPlayingAnimation(MAIN_TRACK, "draw");
    }

    public void onGunReleaseBolt() {
        this.controller.removeAnimation(BOLT_CATCH_STATIC_TRACK);
    }

    public void onIdleHoldingPose() {
        if (!this.isPlayingAnimation(HOLDING_POSE_STATIC_TRACK, "static_idle")) {
            this.controller.runAnimation(HOLDING_POSE_STATIC_TRACK, "static_idle", ObjectAnimation.PlayType.LOOP, 0.0f);
        }
    }

    private boolean isNamedWalkAnimation(String animationName) {
        return "walk_sideway".equals(animationName) || "walk_forward".equals(animationName) || "walk_backward".equals(animationName) || "walk_aiming".equals(animationName);
    }

    private boolean tryRunShootAnimation(int track) {
        ObjectAnimationRunner runner = this.controller.getAnimation(track);
        if (runner != null && runner.isRunning() && "shoot".equals(runner.getAnimation().name)) {
            return false;
        }
        if (runner != null && runner.getTransitionTo() != null && "shoot".equals(runner.getTransitionTo().getAnimation().name)) {
            return false;
        }
        this.controller.runAnimation(track, "shoot", ObjectAnimation.PlayType.PLAY_ONCE_STOP, 0.0f);
        return true;
    }
}

